<?php 
include 'db.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Catalogue</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    /* General styling */
    body {
      background-color: #f8f9fa;
    }

    .header {
      padding: 10px 15px;
      background-color: #f1f1f1ab;
      /* border-bottom: 1px solid #ddd; */
    }

    .header h5 {
      margin: 0;
      font-size: 16px;
      font-weight: 600;
    }

    .header button {
      font-size: 14px;
      color: #007bff;
    }


    .nav {
        display: flex;
      background-color: #f1f1f1ab;
      /* border-bottom: 1px solid #ddd; */
     
    }

    .nav-item {
        flex: 1;
      text-align: center;
      font-size: 15px;
      color: #888;
      cursor: pointer !important;
      border-bottom: 2px solid transparent;
    }

    .nav-item .nav-link.active {
        color: #007bff !important;
      font-weight: 700;
      border-bottom: 2px solid #007bff !important;
    }
    .card {
      margin-right:10px;
      margin-left:10px;
      border: none;
      margin-bottom: 15px;
      border-radius:10px;
    }

    .card h6 {
      margin: 0;
      font-size: 18px;
      font-weight: 500;
    }

    .card small {
      color: #6c757d;
    }

    .toggle-switch {
      position: relative;
      width: 30px;
      height: 15px;
    }

    .toggle-switch input {
      display: none;
    }

    .toggle-switch label {
      display: block;
      width: 100%;
      height: 100%;
      background-color: #ccc;
      border-radius: 15px;
      cursor: pointer;
      position: relative;
    }

    /* .toggle-switch label::after {
      content: '';
      position: absolute;
      width: 16px;
      height: 16px;
      background: white;
      border-radius: 50%;
      top: 2px;
      left: 2px;
      transition: all 0.3s;
    } */

    
    .toggle-switch label::after {
      content: '';
      position: absolute;
      width: 14px;
      height: 14px;
      background: white;
      border-radius: 50%;
      top: 0px;
      left: -4px;
      transition: all 0.3s;
    }

    .online-txt {
      font-size: 14px !important;
    }
    .online-txt-1 {
      font-size: 14px !important;
      /* padding-right: 15px; */
    }
    .toggle-switch input:checked + label {
      background-color: #007bff;
    }

    .toggle-switch input:checked + label::after {
      transform: translateX(20px);
    }

    .btn-share {
      font-size: 14px;
      color: #007bff !important;
    }

    .btn-share img {
      /* margin-right: 5px; */
    }

    #add-category-btn {
      position: fixed;
      bottom: 20px;
      right: 20px;
      border-radius:25px;
      padding: 12px 20px;
      font-size: 14px;
      text-align: center;
    }

    .text-span {
    font-size: 20px;
    font-weight: 600;
}

.text-muted {
  font-size: 16px;
}

.dropdown-menu .dropdown-item {
  padding: 10px;
}

.dropdown-menu .dropdown-item:hover {
  background-color: #f1f1f1;
  color: #007bff;
} 

.header {
  /* box-shadow: rgba(50, 50, 93, 0.25) 0px 2px 5px -1px, rgba(0, 0, 0, 0.3) 0px 1px 3px -1px; */

}

.card-border {
  border: 1px solid #f1f1f1 !important;
  box-shadow: rgba(50, 50, 93, 0.25) 0px 2px 5px -1px, rgba(0, 0, 0, 0.3) 0px 1px 3px -1px;
  padding: 10px;
}

hr{
  border-top: 1px solid #b9b9c1 !important;
  margin: 15px 0px 8px 0px !important;
}

.p-3 {
    padding: 0.5rem 1rem 0rem 1rem!important;
}

.mb-3 {
  padding: 0.5rem 1rem 0rem 1rem!important;
}

.toggle-section {
  padding: 0px 0px 0px 15px;
}


/* increase decrease button */
          form {
            width: 200px;
            /* margin: 0 auto; */
            text-align: right;
            /* padding-top: 50px;*/
            padding-right: 15px;
          }

        .value-button {
          display: inline-block;
          border: 1px solid #007bff;
          margin: 0px;
          width: 30px;
          height: 20px;
          text-align: center;
          vertical-align: middle;
          padding: 14px 0;
          background: #007bff;
          color: #fff;
          -webkit-touch-callout: none;
          -webkit-user-select: none;
          -khtml-user-select: none;
          -moz-user-select: none;
          -ms-user-select: none;
          user-select: none;
          line-height: -0px !important;
        }

        .value-button:hover {
            background-color: #007bff;
            border: 1px solid #007bff;
        }

        .value-button:hover {
            cursor: pointer;
        }

        form #decrease {
            margin-right: -4px;
            border-radius: 30px 0 0 30px;
            line-height: 5px;
        }

        form #increase {
            margin-left: -4px;
            border-radius: 0 30px 30px 0;
            line-height: 5px;
        }

        form #input-wrap {
            margin: 0px;
            padding: 0px;
        }

        input#number {
            text-align: center;
            border: none;
            border-top: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            margin: 0px;
            width: 30px;
            height: 30px;
            border-radius: 0px;
            padding-bottom: 6px;
        }

        input#number1 {
            text-align: center;
            border: none;
            border-top: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            margin: 0px;
            width: 40px;
            height: 40px;
            border-radius: 0px;
            padding-bottom: 6px;
        }

        .value-button:active {
            background-color: #007bff;
            box-shadow: 1px 0px 2px rgb(0,0,0.5);
        }

        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
                -webkit-appearance: none;
                margin: 0;
        }   

  </style>
</head>
<body>

  <!-- Header -->
  <div class="header d-flex justify-content-between align-items-center">
    <div class="col-md-6">
    <i class="fa fa-arrow-left" onclick="window.location='dashboard.php'"></i> <span class="text-span">&nbsp;&nbsp;Catalogue</span>    
    </div>
  
    <button class="btn d-flex align-items-center">
    <div class="d-flex flex-column text-center me-0">
        <i class="fa fa-angle-up"></i>
        <i class="fa fa-angle-down"></i>
    </div>
    <div style="font-weight: 600; font-size: 17px;">
       &nbsp; Move
    </div>
</button>


  </div>

  <!-- Tabs -->
  <ul class="nav nav-underline">
    <li class="nav-item">
      <a class="nav-link active" href="#products" data-bs-toggle="tab">Products</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="#inventory" data-bs-toggle="tab">Inventory</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="#categories" data-bs-toggle="tab">Categories</a>
    </li>
  </ul>

  <div class="tab-content mt-3">
    <!-- Products Tab -->
    <div class="tab-pane fade show active" id="products" role="tabpanel" aria-labelledby="products-tab">
    <?php
    // Include database connection
    include 'db.php';

    // Query to fetch products
    $products = "SELECT * FROM product WHERE delete_status=0";
    $proresult = mysqli_query($connection, $products);

    if ($proresult && mysqli_num_rows($proresult) > 0) {
        // Loop through the products
        while ($row = mysqli_fetch_assoc($proresult)) {
            ?>
            <div class="card card-border">
                <div class="d-flex align-items-center">
                    <img src="<?php echo $row['productimage'] ?? 'https://via.placeholder.com/50'; ?>" alt="Product Image" class="rounded me-3" style="width:60px; height:60px;">
                    <div class="flex-grow-1">
                        <h6 class="mb-0"><?php echo htmlspecialchars($row['productname']); ?></h6>
                        <small class="text-muted"><?php echo htmlspecialchars($row['category'] ?? 'No categories'); ?></small>
                    </div>
                    <div class="dropdown ms-auto" >
                        <i class="fa fa-ellipsis-v" data-bs-toggle="dropdown" style="cursor:pointer; padding: 20px 20px 10px 20px;"></i>
                        <ul class="dropdown-menu dropdown-menu-end">
                          <li>
                            <a class="dropdown-item" href="editproduct.php?id=<?php echo $row['id']; ?>">Edit</a>
                          </li>
                          <li>
                          <a class="dropdown-item" href="#" onclick="confirmDelete(<?php echo $row['id']; ?>)">Delete</a>
                          </li>
                        </ul>
                      </div>
                </div>
                <hr class="">
                <div class="d-flex justify-content-between align-items-center mt-0">
                    <div class="d-flex align-items-center toggle-section">
                    <div class="toggle-switch me-2">
                        <input type="checkbox" id="online<?php echo $row['id']; ?>" 
                              <?php echo ($row['mode'] == '1' ? 'checked' : ''); ?> 
                              onchange="updateMode(<?php echo $row['id']; ?>, this.checked)">
                        <label for="online<?php echo $row['id']; ?>"></label>
                    </div>

                        <span class="online-txt"><?php echo ($row['mode'] == '1' ? 'Online' : 'Offline'); ?></span>
                    </div>
                    <button class="online-txt-1 btn d-flex align-items-center">
                     <?php echo $row['qty']?>
                    </button>
                </div>
            </div>
            <?php
        } 
    } else {
        echo "<p>No products found.</p>";
    }
    ?>

<button type="button" class="btn btn-primary" id="add-category-btn" onclick="window.location.href='productsAdd.php'">+ ADD</button>

     <!-- Bootstrap Modal for Deletion Confirmation -->
  <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          Are you sure you want to delete this product? This action cannot be undone.
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">No</button>
          <button type="button" class="btn btn-danger" id="confirmDeleteBtn" onclick="">Yes, Delete</button>
        </div>
      </div>
    </div>
  </div>
</div>

    <!-- Inventory Tab -->
    <div class="tab-pane fade" id="inventory" role="tabpanel" aria-labelledby="inventory-tab">
    <div class="card p-3 mb-3 card-border">
        <div class="d-flex align-items-center">
          <img src="https://via.placeholder.com/50" alt="Category Image" class="rounded me-3" style="width: 60px; height: 60px;">
          <div class="flex-grow-1">
            <h6 class="mb-0">Instant Eats</h6>
            <small class="text-muted">2 Subcategories</small>
          </div>
          <div class="dropdown ms-auto" >
            <i class="fa fa-ellipsis-v" data-bs-toggle="dropdown" style="cursor:pointer; padding: 20px 20px 10px 20px;"></i>
            <ul class="dropdown-menu dropdown-menu-end">
              <li>
                <a class="dropdown-item" href="editproduct.php?id=<?php echo $row['id']; ?>">Edit</a>
              </li>
              <li>
              <a class="dropdown-item" href="#" onclick="confirmDelete(<?php echo $row['id']; ?>)">Delete</a>
              </li>
            </ul>
          </div>
        </div>
        <hr class="">
        <div class="d-flex justify-content-between align-items-center mt-0">
          <div class="d-flex align-items-center toggle-section">
            <div class="toggle-switch me-2">
              <input type="checkbox" id="online4" checked>
              <label for="online4"></label>
            </div>
            <span class="online-txt">Online</span>
          </div>
          <!-- <button class="online-txt btn d-flex align-items-center btn-share">
            <i class="fa fa-share-alt me-1"></i>&nbsp;&nbsp;
            Share
          </button> -->
          <form>
                <div class="value-button" id="decrease" onclick="decreaseValue()" value="Decrease Value">-</div>
                <input type="number" id="number" value="0" />
                <div class="value-button" id="increase" onclick="increaseValue()" value="Increase Value">+</div>
            </form>
        </div>
      </div>

      <div class="card p-3 mb-3 card-border">
        <div class="d-flex align-items-center">
          <img src="https://via.placeholder.com/50" alt="Category Image" class="rounded me-3" style="width: 60px; height: 60px;">
          <div class="flex-grow-1">
            <h6 class="mb-0">Sanitary & Hygiene</h6>
            <small class="text-muted">3 Subcategories</small>
          </div>
          <div class="dropdown ms-auto" >
                        <i class="fa fa-ellipsis-v" data-bs-toggle="dropdown" style="cursor:pointer; padding: 20px 20px 10px 20px;"></i>
                        <ul class="dropdown-menu dropdown-menu-end">
                          <li>
                            <a class="dropdown-item" href="editproduct.php?id=<?php echo $row['id']; ?>">Edit</a>
                          </li>
                          <li>
                          <a class="dropdown-item" href="#" onclick="confirmDelete(<?php echo $row['id']; ?>)">Delete</a>
                          </li>
                        </ul>
                      </div>
        </div>
        <hr class="">
        <div class="d-flex justify-content-between align-items-center mt-0">
          <div class="d-flex align-items-center toggle-section">
            <div class="toggle-switch me-2">
              <input type="checkbox" id="online5" checked>
              <label for="online5"></label>
            </div>
            <span class="online-txt">Online</span>
          </div>
          <form>
                <div class="value-button" id="decrease" onclick="decreaseValue()" value="Decrease Value">-</div>
                <input type="number" id="number" value="0" />
                <div class="value-button" id="increase" onclick="increaseValue()" value="Increase Value">+</div>
            </form>
        </div>
      </div>

      <div class="card p-3 mb-3 card-border">
        <div class="d-flex align-items-center">
          <img src="https://via.placeholder.com/50" alt="Category Image" class="rounded me-3" style="width: 60px; height: 60px;">
          <div class="flex-grow-1">
            <h6 class="mb-0">Spices & Masalas</h6>
            <small class="text-muted">0 Subcategories</small>
          </div>
          <div class="dropdown ms-auto" >
                        <i class="fa fa-ellipsis-v" data-bs-toggle="dropdown" style="cursor:pointer; padding: 20px 20px 10px 20px;"></i>
                        <ul class="dropdown-menu dropdown-menu-end">
                          <li>
                            <a class="dropdown-item" href="editproduct.php?id=<?php echo $row['id']; ?>">Edit</a>
                          </li>
                          <li>
                          <a class="dropdown-item" href="#" onclick="confirmDelete(<?php echo $row['id']; ?>)">Delete</a>
                          </li>
                        </ul>
                      </div>
        </div>
        <hr class="">
        <div class="d-flex justify-content-between align-items-center mt-0">
          <div class="d-flex align-items-center toggle-section">
            <div class="toggle-switch me-2">
              <input type="checkbox" id="online6" checked>
              <label for="online6"></label>
            </div>
            <span class="online-txt">Online</span>
          </div>
          <form>
                <div class="value-button" id="decrease" onclick="decreaseValue()" value="Decrease Value">-</div>
                <input type="number" id="number" value="0" />
                <div class="value-button" id="increase" onclick="increaseValue()" value="Increase Value">+</div>
            </form>
        </div>
      </div>
    </div>

    <!-- Categories Tab -->
    <div class="tab-pane fade" id="categories" role="tabpanel" aria-labelledby="categories-tab">
      <!-- Categories Cards -->

      <?php 
$category = "SELECT * FROM category WHERE delete_status=0";
$catresult = mysqli_query($connection, $category);

if ($catresult && mysqli_num_rows($catresult) > 0) {
    // Loop through the products
    while ($row = mysqli_fetch_assoc($catresult)) {
        ?>
        <div class="card card-border">
          <div class="d-flex align-items-center" onclick="window.location.href='category-2.php?id=<?php echo $row['id'];?>'">
              <img src="<?php echo $row['image']; ?>" alt="Category Image" class="rounded me-3" style="width: 60px; height: 60px; object-fit: cover;">
              <div class="flex-grow-1"  >
                  <h6 class="mb-0"><?php echo $row['category']; ?></h6>
                  <small class="text-muted">Hot drinks</small>
              </div>
              <div class="dropdown ms-auto"  onclick="event.stopPropagation();" >
                  <i class="fa fa-ellipsis-v" data-bs-toggle="dropdown" style="cursor:pointer; padding: 20px 20px 10px 20px;" ></i>
                  <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                      <a class="dropdown-item" href="editproduct.php?id=<?php echo $row['id']; ?>">Edit</a>
                    </li>
                    <li>
                    <a class="dropdown-item" href="#" onclick="confirmDelete(<?php echo $row['id']; ?>)">Delete</a>
                    </li>
                  </ul>
              </div>
          </div>
          <hr class="">
          <div class="d-flex justify-content-between align-items-center mt-0">
              <div class="d-flex align-items-center toggle-section">
                <div class="toggle-switch me-2">
                    <input type="checkbox" id="online<?php echo $row['id']; ?>" 
                          <?php echo ($row['mode'] == '1' ? 'checked' : ''); ?> 
                          onchange="updateMode(<?php echo $row['id']; ?>, this.checked)">
                    <label for="online<?php echo $row['id']; ?>"></label>
                </div>
                <span class="online-txt"><?php echo ($row['mode'] == '1' ? 'Online' : 'Offline'); ?></span>
              </div>
              <button class="online-txt-1 btn d-flex align-items-center">100
                <?php //echo $row['qty']?>
              </button>
          </div>
        </div>
        <?php
    }
} else {
    echo "<p>No products found.</p>";
}
?>

<button type="button" class="btn btn-primary" id="add-category-btn" onclick="window.location.href='addcategory.php'">+ CATEGORY</button>
      
    </div>
  </div>

  <!-- Add Category Button -->



  <!-- Bootstrap JS -->
   <!-- Add this before the closing </body> tag -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.11.8/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script>
function updateMode(id, isChecked) {
    // Convert boolean to mode value (1 for checked, 0 for unchecked)
    const mode = isChecked ? 1 : 0;

    // Make an AJAX request to update the mode in the database
    fetch('update_mode.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ id: id, mode: mode })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
           //alert('Mode updated successfully!');
        } else {
            alert('Failed to update mode: ' + data.error);
        }
    })
    .catch(error => {
        console.error('Error updating mode:', error);
    });
}
</script>
<script>
    let productIdToDelete = null;

    // Show the modal to confirm deletion
    function confirmDelete(productId) {
      productIdToDelete = productId;  // Store the product ID to be deleted
      const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
      deleteModal.show();
    }

    // Function to delete the product when user confirms
    function deleteProduct() {
      if (productIdToDelete === null) return;

      const xhr = new XMLHttpRequest();
      xhr.open('POST', 'delete_product.php', true);
      xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
      xhr.send('id=' + productIdToDelete);

      xhr.onload = function () {
        if (xhr.status === 200) {
          window.location.reload();  // Reload to see the changes
        } else {
          alert('Error deleting product');
        }
      };

      // Close the modal after the AJAX request
      const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
      deleteModal.hide();
    }

    // Attach the delete function to the "Yes, Delete" button
    document.getElementById('confirmDeleteBtn').onclick = deleteProduct;
  </script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/hammer.js/2.0.8/hammer.min.js"></script>
<!-- JavaScript to Handle Swipes -->
<script>
    // Tab navigation logic
    const tabLinks = document.querySelectorAll('.nav-link');
    const tabs = Array.from(tabLinks).map(link => link.getAttribute('href').substring(1));

    // Detect swipe
    let startX = 0;

    document.querySelector('.tab-content').addEventListener('touchstart', (e) => {
      startX = e.touches[0].clientX;
    });

    document.querySelector('.tab-content').addEventListener('touchend', (e) => {
      const endX = e.changedTouches[0].clientX;
      const diff = startX - endX;

      const activeTab = document.querySelector('.nav-link.active').getAttribute('href').substring(1);
      const currentIndex = tabs.indexOf(activeTab);

      if (Math.abs(diff) > 50) { // Consider it a swipe if the difference is significant
        if (diff > 0 && currentIndex < tabs.length - 1) {
          // Swiping left
          if (currentIndex === 0 || currentIndex === 1) {
            showTab(currentIndex + 1);
          }
        } else if (diff < 0 && currentIndex > 0) {
          // Swiping right
          if (currentIndex === 1 || currentIndex === 2) {
            showTab(currentIndex - 1);
          }
        }
      }
    });

    function showTab(index) {
      const newTab = document.querySelector(`a[href="#${tabs[index]}"]`);
      newTab.click(); // Trigger Bootstrap's tab change
    }
  </script>



<!-- Increase Decrease BUtton -->

<script>
 document.addEventListener("DOMContentLoaded", () => {
    // Attach event listeners to all increase and decrease buttons
    document.querySelectorAll('.value-button').forEach(button => {
        button.addEventListener('click', () => {
            // Find the corresponding input field for the clicked button
            const inputField = button.parentElement.querySelector('input[type="number"]');
            let currentValue = parseInt(inputField.value, 10); // Get current value
            currentValue = isNaN(currentValue) ? 0 : currentValue; // Handle invalid values
            
            // Increase or decrease value based on the button clicked
            if (button.id === 'increase') {
                inputField.value = currentValue + 1;
            } else if (button.id === 'decrease') {
                inputField.value = currentValue > 0 ? currentValue - 1 : 0; // Prevent negative values
            }
        });
    });
});

</script>

<!-- Toggle checked: Online ? Offline -->
 <script>
 function updateMode(id, isChecked) {
        // Update the text on the frontend based on toggle state
        const span = document.querySelector(`#online${id}`).closest('.toggle-section').querySelector('.online-txt');
        
        if (isChecked) {
            span.textContent = "Online";
        } else {
            span.textContent = "Offline";
        }

        // Send the updated state to the backend using AJAX
        fetch('update_mode.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                id: id,
                mode: isChecked ? '1' : '0', // Send '1' for Online, '0' for Offline
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                console.log("Mode updated successfully.");
            } else {
                console.error("Failed to update mode.");
                // Revert the text back to the previous state in case of failure
                span.textContent = isChecked ? "Offline" : "Online";
            }
        })
        .catch(error => {
            console.error('Error:', error);
            // Revert the text back to the previous state in case of failure
            span.textContent = isChecked ? "Offline" : "Online";
        });
    }

 </script>
</body>
</html>
